#include <windows.h>
#include "array.h"


#define MemAlloc( s )       ((void*) (LocalAlloc( LPTR, s ))
#define MemRealloc( p, s )  LocalReAlloc( (HLOCAL) p, s, 0 )
#define MemFree( p )        LocalFree( (HLOCAL) p )
#define MemSize( p )        LocalSize( (HLOCAL) p )

#define DICKAPI

static void DickArrayAdjustCapacity( DICKARRAY* Array )
  {
    Array->Capacity = MemSize( Array->Items ) / Array->SizeOfItem;
  }

BOOL DICKAPI DickArrayInit( DICKARRAY* Array, int SizeOfItem,
                            int InitialCapacity, int Increment )
  {
    List->SizeOfItem = SizeOfItems;
    List->Count = 0;
    if( Increment < 1 )
      List->Increment = 1;
    else
      List->Increment = Increment;
    if( InitialCapacity < 1 ) InitialCapacity = 1;
    List->Items = MemAlloc( SizeOfItem * InitialCapacity );
    if( List->Items == NULL ) return FALSE;
    DickArrayAdjustCapacity( Array );
    return TRUE;
  }

void DICKAPI DickArrayFree( DICKARRAY* Array )
  {
    if( ! IsBadWritePtr( List->Items, 1 ) ) MemFree( List->Items );
    List->Items = NULL;
    List->Count = 0;
  }

BOOL DICKAPI DickArrayGrow( DICKARRAY* Array, int ItemCount )
  {
    void*  p;

    if( Array->Count + ItemCount >= Array->Capacity ) {
      p = MemRealloc( Array->Items,
                        (Array->Count + Array->Increment
                            * (1 + ItemCount / Array->Increment))
                                    * Array->SizeOfItem );
      if( p == NULL ) return FALSE;
      Array->Items = p;
      DickArrayAdjustCapacity( Array );
    }
    RtlZeroMemory( ((BYTE*) (Array->Items))
                                + Array->Count * Array->SizeOfItem,
                   ItemCount * Array->SizeOfItem );
    Array->Count += ItemCount;
    return TRUE;
  }

BOOL DICKAPI DickArrayAddItem( DICKARRAY* Array, void* Item )
  {
    int  i;

    i = Array->Count;
    if( ! DickArrayGrow( Array, 1 ) ) return FALSE;
    if( Item != NULL )
      RtlMoveMemory( ((BYTE*) (Array->Items)) + i * Array->SizeOfItem,
                     Item, Array->SizeOfItem );
    return TRUE;
  }

void DICKAPI DickArrayRemoveItems( DICKARRAY* Array,
                                   int ItemIndex, int Count )
  {
    int   i;

    if( ItemIndex >= Array->Count || Count < 1 ) return;
    if( ItemIndex + Count > Array->Count )
      Count = Array->Count - ItemIndex;
    i = ItemIndex + Count;
    if( i < Array->Count )
      RtlMoveMemory( ((BYTE*) (Array->Items)) + ItemIndex * Array->SizeOfItem,
                     ((BYTE*) (Array->Items)) + i * Array->SizeOfItem,
                     (Array->Count - i) * Array->SizeOfItem );
    Array->Count -= Count;
  }

void DICKAPI DickArrayShrink( DICKARRAY* Array, int Capacity )
  {
    void*  p;

    if( Capacity < Array->Count ) Capacity = Array->Count;
    if( Capacity < 1 ) Capacity = 1;
    p = MemRealloc( Array->Items,
                      Capacity * Array->SizeOfItem );
    if( p == NULL ) return;
    Array->Items = p;
    DickArrayAdjustCapacity( Array );
  }
